/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.engine.BoundingBox;
import game.entities.WallSocket;
import game.map.GameMap;
import game.world.GameWorld;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.pathfinding.Mover;
import org.newdawn.slick.util.pathfinding.PathFindingContext;
import org.newdawn.slick.util.pathfinding.TileBasedMap;

public class TileBasedMapAdapter2
implements TileBasedMap {
    private GameWorld world;
    private float tileSize;

    public TileBasedMapAdapter2(GameWorld world, float tileSize) {
        this.world = world;
        this.tileSize = tileSize;
    }

    private WallSocket getSocket(PathFindingContext ctx) {
        return ((TileBasedMover)ctx.getMover()).getSocket();
    }

    private Vector2f getPosition(int tx, int ty) {
        return new Vector2f((float)tx * this.tileSize, (float)ty * this.tileSize);
    }

    public boolean blocked(PathFindingContext ctx, int tx, int ty) {
        WallSocket socket = this.getSocket(ctx);
        Vector2f position = this.getPosition(tx, ty);
        BoundingBox cbb = this.world.getPlayer().getBoundingBox();
        GameMap map = this.world.getMap();
        return map.isBlocked(cbb, position);
    }

    public float getCost(PathFindingContext ctx, int tx, int ty) {
        return 1.0f;
    }

    public int getHeightInTiles() {
        return (int)(this.world.getMap().getBounds().getHeight() / this.tileSize);
    }

    public int getWidthInTiles() {
        return (int)(this.world.getMap().getBounds().getWidth() / this.tileSize);
    }

    public void pathFinderVisited(int tx, int ty) {
    }

    public static class TileBasedMover
    implements Mover {
        private WallSocket socket;

        public TileBasedMover(WallSocket wallSocket) {
            this.socket = wallSocket;
        }

        public WallSocket getSocket() {
            return this.socket;
        }
    }
}

