/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MolyJamGame;
import game.engine.Updateable;
import game.engine.util.ImageUtil;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;

public class TitleScreen
implements Updateable {
    private MolyJamGame game;
    private GameContainer container;
    private MenuOption currentOption;
    private EndingOption endingOption;
    private TitleState state;
    private Image titleImage;
    private Image newGameImage;
    private Image newGameSelectedImage;
    private Image aboutImage;
    private Image aboutSelectedImage;
    private Image exitImage;
    private Image exitSelectedImage;
    private int containerWidth;
    private Image aboutScreen1;
    private Image aboutScreen2;
    private Image goodEnding;
    private Image badEnding;
    private Image goodEndingImage;
    private Image goodEndingSelectedImage;
    private Image badEndingImage;
    private Image badEndingSelectedImage;
    private Sound sound;
    private Image titleEnding;

    public void init(MolyJamGame jam, GameContainer container) {
        this.game = jam;
        this.container = container;
        this.currentOption = MenuOption.start;
        this.state = TitleState.menu;
        this.endingOption = EndingOption.good;
        this.containerWidth = container.getWidth();
        try {
            this.titleImage = ImageUtil.load("/assets/graphics/title.png");
            this.newGameImage = ImageUtil.load("/assets/graphics/new_game.png");
            this.newGameSelectedImage = ImageUtil.load("/assets/graphics/new_game_s.png");
            this.aboutImage = ImageUtil.load("/assets/graphics/about.png");
            this.aboutSelectedImage = ImageUtil.load("/assets/graphics/about_s.png");
            this.exitImage = ImageUtil.load("/assets/graphics/exit.png");
            this.exitSelectedImage = ImageUtil.load("/assets/graphics/exit_s.png");
            this.goodEndingImage = ImageUtil.load("/assets/graphics/g_end_button.png");
            this.goodEndingSelectedImage = ImageUtil.load("/assets/graphics/g_end_button_s.png");
            this.badEndingImage = ImageUtil.load("/assets/graphics/b_end_button.png");
            this.badEndingSelectedImage = ImageUtil.load("/assets/graphics/b_end_button_s.png");
            this.aboutScreen1 = ImageUtil.load("/assets/graphics/about_screen.png");
            this.aboutScreen2 = ImageUtil.load("/assets/graphics/about_screen2.png");
            this.goodEnding = ImageUtil.load("/assets/graphics/good_ending.png");
            this.badEnding = ImageUtil.load("/assets/graphics/bad_ending.png");
            this.titleEnding = ImageUtil.load("/assets/graphics/choose_ending.png");
            this.sound = new Sound("/assets/audio/menuEffect1.wav");
        }
        catch (SlickException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        container.getInput().clearKeyPressedRecord();
    }

    public void update(MolyJamGame jam, GameContainer container, int dt) {
        try {
            if (this.state == TitleState.menu) {
                if (container.getInput().isKeyPressed(28)) {
                    container.getInput().clearKeyPressedRecord();
                    switch (this.currentOption) {
                        case start: {
                            jam.initGame(container);
                            this.sound.play();
                            return;
                        }
                        case information: {
                            this.state = TitleState.about;
                            this.sound.play();
                            return;
                        }
                        case exit: {
                            System.exit(0);
                            return;
                        }
                    }
                } else if (container.getInput().isKeyPressed(208)) {
                    int i = Math.min(MenuOption.values().length - 1, this.currentOption.ordinal() + 1);
                    this.currentOption = MenuOption.values()[i];
                    this.sound.play();
                } else if (container.getInput().isKeyPressed(200)) {
                    int i = Math.max(0, this.currentOption.ordinal() - 1);
                    this.currentOption = MenuOption.values()[i];
                    this.sound.play();
                }
            } else if (this.state == TitleState.about) {
                if (container.getInput().isKeyPressed(28)) {
                    this.state = TitleState.about2;
                    container.getInput().clearKeyPressedRecord();
                    this.sound.play();
                }
            } else if (this.state == TitleState.about2) {
                if (container.getInput().isKeyPressed(28)) {
                    this.state = TitleState.menu;
                    container.getInput().clearKeyPressedRecord();
                    this.sound.play();
                }
            } else if (this.state == TitleState.menuEnding) {
                if (container.getInput().isKeyPressed(28)) {
                    container.getInput().clearKeyPressedRecord();
                    switch (this.endingOption) {
                        case good: {
                            this.state = TitleState.goodEnding;
                            this.sound.play();
                            return;
                        }
                        case bad: {
                            this.state = TitleState.badEnding;
                            this.sound.play();
                            return;
                        }
                    }
                } else if (container.getInput().isKeyPressed(208)) {
                    int i = Math.min(EndingOption.values().length - 1, this.currentOption.ordinal() + 1);
                    this.endingOption = EndingOption.values()[i];
                    this.sound.play();
                } else if (container.getInput().isKeyPressed(200)) {
                    int i = Math.max(0, this.currentOption.ordinal() - 1);
                    this.endingOption = EndingOption.values()[i];
                    this.sound.play();
                }
            } else if (this.state == TitleState.goodEnding) {
                if (container.getInput().isKeyPressed(28)) {
                    this.state = TitleState.menu;
                    container.getInput().clearKeyPressedRecord();
                    this.sound.play();
                }
            } else if (this.state == TitleState.badEnding && container.getInput().isKeyPressed(28)) {
                this.state = TitleState.menu;
                container.getInput().clearKeyPressedRecord();
                this.sound.play();
            }
        }
        catch (SlickException e) {
            throw new RuntimeException(e);
        }
    }

    public void setState(TitleState state) {
        this.state = state;
    }

    public void render(MolyJamGame jam, GameContainer container, Graphics graphic) {
        graphic.pushTransform();
        graphic.scale(2.0f, 2.0f);
        if (this.state == TitleState.menu) {
            int titleWidth = this.titleImage.getWidth();
            int titleHeight = this.titleImage.getHeight();
            int buttonWidth = this.newGameImage.getWidth();
            int buttonHeight = this.newGameImage.getHeight();
            switch (this.currentOption) {
                case start: {
                    graphic.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    graphic.drawImage(this.newGameSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    graphic.drawImage(this.aboutImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    graphic.drawImage(this.exitImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                    break;
                }
                case information: {
                    graphic.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    graphic.drawImage(this.newGameImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    graphic.drawImage(this.aboutSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    graphic.drawImage(this.exitImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                    break;
                }
                case exit: {
                    graphic.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    graphic.drawImage(this.newGameImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    graphic.drawImage(this.aboutImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    graphic.drawImage(this.exitSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                }
            }
        } else if (this.state == TitleState.about) {
            this.aboutScreen1.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        } else if (this.state == TitleState.about2) {
            this.aboutScreen2.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        } else if (this.state == TitleState.menuEnding) {
            int titleHeight = 150;
            int buttonWidth = this.goodEndingImage.getWidth();
            int buttonHeight = this.goodEndingImage.getHeight();
            this.titleEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
            switch (this.endingOption) {
                case good: {
                    graphic.drawImage(this.goodEndingSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    graphic.drawImage(this.badEndingImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    break;
                }
                case bad: {
                    graphic.drawImage(this.goodEndingImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    graphic.drawImage(this.badEndingSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                }
            }
        } else if (this.state == TitleState.goodEnding) {
            this.goodEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        } else if (this.state == TitleState.badEnding) {
            this.badEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        }
        graphic.popTransform();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EndingOption {
        good,
        bad;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MenuOption {
        start,
        information,
        exit;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleState {
        menu,
        about,
        about2,
        menuEnding,
        goodEnding,
        badEnding;

    }
}

