/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class GameCamera {
    private Entity stalked;
    private float scale = 1.0f;
    private BoundingBox screenBounds;
    private Vector2f screenPos;

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void attach(Entity stalked) {
        this.stalked = stalked;
    }

    public void init(int screenWidth, int screenHeight) {
        this.screenPos = new Vector2f(0.0f, 0.0f);
        this.screenBounds = new BoundingBox((float)(-screenWidth) / this.scale / 2.0f, (float)(-screenHeight) / this.scale / 2.0f, (float)screenWidth / this.scale, (float)screenHeight / this.scale);
    }

    public void update(GameWorld world, int dt) {
        Vector2f origin = this.stalked == null ? this.screenPos : this.stalked.getPos();
        BoundingBox mapBounds = world.getMap().getBounds();
        float ox = 0.0f;
        float oy = 0.0f;
        if (this.screenBounds.getMinX(origin) < mapBounds.getMinX(0.0f, 0.0f)) {
            ox = mapBounds.getMinX(0.0f, 0.0f) - this.screenBounds.getMinX(origin);
        } else if (this.screenBounds.getMaxX(origin) > mapBounds.getMaxX(0.0f, 0.0f)) {
            ox = mapBounds.getMaxX(0.0f, 0.0f) - this.screenBounds.getMaxX(origin);
        }
        if (this.screenBounds.getMinY(origin) < mapBounds.getMinY(0.0f, 0.0f)) {
            oy = mapBounds.getMinY(0.0f, 0.0f) - this.screenBounds.getMinY(origin);
        } else if (this.screenBounds.getMaxY(origin) > mapBounds.getMaxY(0.0f, 0.0f)) {
            oy = mapBounds.getMaxY(0.0f, 0.0f) - this.screenBounds.getMaxY(origin);
        }
        this.screenPos.set(origin.x + ox, origin.y + oy);
    }

    public BoundingBox getScreenBounds() {
        return this.screenBounds;
    }

    public Vector2f getScreenPos() {
        return this.screenPos;
    }

    public void apply(Graphics g, GameContainer container) {
        g.translate(Math.round((float)container.getWidth() / 2.0f), Math.round((float)container.getHeight() / 2.0f));
        g.scale(this.scale, this.scale);
        g.translate(-Math.round(this.screenPos.x), -Math.round(this.screenPos.y));
    }
}

