/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import game.engine.util.ImageUtil;
import game.objects.Boss;
import game.objects.BossDoor;
import game.objects.GameObject;
import game.objects.NPC;
import game.objects.Player;
import game.objects.Projectile;
import game.objects.TimedDoor;
import game.objects.WallSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleIO;
import org.newdawn.slick.util.xml.XMLElement;
import org.newdawn.slick.util.xml.XMLElementList;
import org.newdawn.slick.util.xml.XMLParser;

public class ObjectLoader {
    private HashMap<String, Animation> animations = new HashMap();
    private HashMap<String, SpriteSheet> spriteSheets = new HashMap();
    private HashMap<String, BoundingBox> rectangles = new HashMap();
    private HashMap<String, GameObject> gameObjects = new HashMap();
    private HashMap<String, String> emitters = new HashMap();
    private HashMap<String, Audio> audio = new HashMap();

    public ObjectLoader() {
        try {
            this.loadSpriteSheets("/assets/xml/spritesheets.xml");
            this.loadRectangles("/assets/xml/rectangles.xml");
            this.loadAnimations("/assets/xml/animations.xml");
            this.loadEmitters("/assets/xml/particleemitters.xml");
            this.loadAudio("/assets/xml/audio.xml");
            this.loadGameObjects("/assets/xml/gameobjects.xml");
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public GameObject createObject(String objectName) {
        return this.gameObjects.get(objectName).clone();
    }

    private void loadRectangles(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList rectangleList = xmle.getChildrenByName("rectangle");
        int nbrRects = rectangleList.size();
        for (int i = 0; i < nbrRects; ++i) {
            XMLElement currRect = rectangleList.get(i);
            String name = currRect.getAttribute("name");
            XMLElement attribs = currRect.getChildrenByName("attribs").get(0);
            float x = (float)attribs.getDoubleAttribute("x");
            float y = (float)attribs.getDoubleAttribute("y");
            float width = (float)attribs.getDoubleAttribute("width");
            float height = (float)attribs.getDoubleAttribute("height");
            this.rectangles.put(name, new BoundingBox(x, y, width, height));
        }
    }

    private void loadGameObjects(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList gameObjectList = xmle.getChildrenByName("gameobject");
        int nbrObjects = gameObjectList.size();
        for (int i = 0; i < nbrObjects; ++i) {
            XMLElement currObject = gameObjectList.get(i);
            String name = currObject.getAttribute("name");
            String type = currObject.getAttribute("type");
            String bbMovementName = currObject.getChildrenByName("bb_movement").get(0).getAttribute("name");
            String bbCollisionName = currObject.getChildrenByName("bb_collision").get(0).getAttribute("name");
            String bbActualName = currObject.getChildrenByName("bb_actual").get(0).getAttribute("name");
            BoundingBox bbMovement = this.rectangles.get(bbMovementName);
            BoundingBox bbCollision = this.rectangles.get(bbCollisionName);
            BoundingBox bbActual = this.rectangles.get(bbActualName);
            XMLElementList animationList = currObject.getChildrenByName("animations").get(0).getChildrenByName("animation");
            int nbrAnimations = animationList.size();
            HashMap<String, ArrayList<Animation>> stateMap = new HashMap<String, ArrayList<Animation>>();
            for (int k = 0; k < nbrAnimations; ++k) {
                XMLElement currAnimation = animationList.get(k);
                String state = currAnimation.getAttribute("state");
                String animationName = currAnimation.getAttribute("name");
                ArrayList<Animation> tmp = (ArrayList<Animation>)stateMap.get(state);
                if (tmp == null) {
                    tmp = new ArrayList<Animation>();
                    stateMap.put(state, tmp);
                }
                tmp.add(this.animations.get(animationName));
            }
            HashMap<String, ConfigurableEmitter> emitterMap = new HashMap<String, ConfigurableEmitter>();
            XMLElementList particleList = currObject.getChildrenByName("particles");
            if (particleList.size() > 0) {
                particleList = particleList.get(0).getChildrenByName("particle");
                int nbrEmitters = particleList.size();
                for (int k = 0; k < nbrEmitters; ++k) {
                    XMLElement currEmitter = particleList.get(k);
                    String emitterID = currEmitter.getAttribute("name");
                    String emitterName = currEmitter.getChildrenByName("particle_emitter").get(0).getAttribute("name");
                    String particleImage = currEmitter.getChildrenByName("particleimage").get(0).getAttribute("img");
                    ConfigurableEmitter tmpConf = null;
                    try {
                        tmpConf = ParticleIO.loadEmitter(this.getClass().getResourceAsStream(this.emitters.get(emitterName)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    tmpConf.setImageName(particleImage);
                    boolean customCol = currEmitter.getChildrenByName("custom_color").get(0).getAttribute("on_or_off").equals("on");
                    if (customCol) {
                        ArrayList<ConfigurableEmitter.ColorRecord> colors;
                        XMLElement startCol = currEmitter.getChildrenByName("color_start").get(0);
                        XMLElement endCol = currEmitter.getChildrenByName("color_end").get(0);
                        float r_s = (float)startCol.getDoubleAttribute("r");
                        float g_s = (float)startCol.getDoubleAttribute("g");
                        float b_s = (float)startCol.getDoubleAttribute("b");
                        float r_e = (float)endCol.getDoubleAttribute("r");
                        float g_e = (float)endCol.getDoubleAttribute("g");
                        float b_e = (float)endCol.getDoubleAttribute("b");
                        tmpConf.colors = colors = new ArrayList<ConfigurableEmitter.ColorRecord>();
                        ConfigurableEmitter configurableEmitter = tmpConf;
                        configurableEmitter.getClass();
                        colors.add(new ConfigurableEmitter.ColorRecord(configurableEmitter, 0.0f, new Color(r_s, g_s, b_s)));
                        ConfigurableEmitter configurableEmitter2 = tmpConf;
                        configurableEmitter2.getClass();
                        colors.add(new ConfigurableEmitter.ColorRecord(configurableEmitter2, 1.0f, new Color(r_e, g_e, b_e)));
                    }
                    emitterMap.put(emitterID, tmpConf);
                }
            }
            HashMap<String, Audio> audioMap = new HashMap<String, Audio>();
            XMLElementList audioList = currObject.getChildrenByName("audio");
            if (audioList.size() > 0) {
                audioList = audioList.get(0).getChildrenByName("effect");
                int nbrEmitters = audioList.size();
                for (int k = 0; k < nbrEmitters; ++k) {
                    XMLElement currEffect = audioList.get(k);
                    String effectName = currEffect.getAttribute("name");
                    String effectType = currEffect.getAttribute("type");
                    audioMap.put(effectName, this.audio.get(effectType));
                }
            }
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            XMLElementList propertyList = currObject.getChildrenByName("properties");
            if (propertyList.size() > 0) {
                propertyList = propertyList.get(0).getChildrenByName("property");
                int nbrProperties = propertyList.size();
                for (int k = 0; k < nbrProperties; ++k) {
                    XMLElement currProperty = propertyList.get(k);
                    String propertyKey = currProperty.getAttribute("key");
                    String propertyValue = currProperty.getAttribute("value");
                    propertyMap.put(propertyKey, propertyValue);
                }
            }
            if (type.equals("player")) {
                this.gameObjects.put(name, new Player(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (type.equals("npc")) {
                this.gameObjects.put(name, new NPC(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (type.equals("projectile")) {
                this.gameObjects.put(name, new Projectile(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (type.equals("socket")) {
                this.gameObjects.put(name, new WallSocket(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (type.equals("timeddoor")) {
                this.gameObjects.put(name, new TimedDoor(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (type.equals("bossdoor")) {
                this.gameObjects.put(name, new BossDoor(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
                continue;
            }
            if (!type.equals("boss")) continue;
            this.gameObjects.put(name, new Boss(stateMap, bbMovement, bbCollision, bbActual, emitterMap, audioMap, propertyMap));
        }
    }

    private void loadAnimations(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList animationList = xmle.getChildrenByName("animation");
        int nbrAnimations = animationList.size();
        for (int i = 0; i < nbrAnimations; ++i) {
            XMLElement curranimation = animationList.get(i);
            String name = curranimation.getAttribute("name");
            boolean loop = Boolean.valueOf(curranimation.getAttribute("loop", "true"));
            String sheetName = curranimation.getChildrenByName("spritesheet").get(0).getAttribute("name");
            SpriteSheet sheet = this.spriteSheets.get(sheetName);
            XMLElement frameList = curranimation.getChildrenByName("frames").get(0);
            XMLElementList frames = frameList.getChildrenByName("frame");
            int nbrFrames = frames.size();
            int[] coords = new int[nbrFrames * 2];
            int[] lengths = new int[nbrFrames];
            int ix = 0;
            for (int k = 0; k < nbrFrames; ++k) {
                XMLElement currFrame = frames.get(k);
                coords[ix++] = currFrame.getIntAttribute("x");
                coords[ix++] = currFrame.getIntAttribute("y");
                lengths[k] = currFrame.getIntAttribute("length");
            }
            Animation animation = new Animation(sheet, coords, lengths);
            animation.setLooping(loop);
            this.animations.put(name, animation);
        }
    }

    private void loadSpriteSheets(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList spritesheetList = xmle.getChildrenByName("spritesheet");
        int nbrSheets = spritesheetList.size();
        for (int i = 0; i < nbrSheets; ++i) {
            XMLElement currspritesheet = spritesheetList.get(i);
            String name = currspritesheet.getAttribute("name");
            String sheet_filename = currspritesheet.getChildrenByName("file").get(0).getAttribute("path");
            XMLElement tileinfo = currspritesheet.getChildrenByName("tile").get(0);
            int tileWidth = tileinfo.getIntAttribute("w");
            int tileHeight = tileinfo.getIntAttribute("h");
            int tileSpacing = tileinfo.getIntAttribute("spacing");
            int tileMargin = tileinfo.getIntAttribute("margin");
            Image tmp = ImageUtil.load(sheet_filename);
            this.spriteSheets.put(name, new SpriteSheet(tmp, tileWidth, tileHeight, tileSpacing, tileMargin));
        }
    }

    private void loadEmitters(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList emitterList = xmle.getChildrenByName("particleemitter");
        int nbrEmitters = emitterList.size();
        for (int i = 0; i < nbrEmitters; ++i) {
            XMLElement emitter = emitterList.get(i);
            String name = emitter.getAttribute("name");
            String conf = emitter.getAttribute("conffile");
            this.emitters.put(name, conf);
        }
    }

    private void loadAudio(String filename) throws SlickException {
        XMLParser parser = new XMLParser();
        XMLElement xmle = parser.parse(filename, this.getClass().getResourceAsStream(filename));
        XMLElementList emitterList = xmle.getChildrenByName("audio");
        int nbrEmitters = emitterList.size();
        for (int i = 0; i < nbrEmitters; ++i) {
            XMLElement emitter = emitterList.get(i);
            String name = emitter.getAttribute("name");
            String file = emitter.getAttribute("file");
            try {
                this.audio.put(name, AudioLoader.getAudio("WAV", new BufferedInputStream(this.getClass().getResourceAsStream(file))));
                continue;
            }
            catch (IOException e) {
                throw new SlickException("Failed to load audio effect.", e);
            }
        }
    }
}

