/*
 * Decompiled with CFR 0.152.
 */
package game.engine.loader;

import game.engine.BoundingBox;
import game.engine.loader.AssetStore;
import game.engine.loader.AssetXMLLoader;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.LoaderException;
import game.engine.util.ImageUtil;
import game.entities.Entity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleIO;
import org.newdawn.slick.util.xml.SlickXMLException;
import org.newdawn.slick.util.xml.XMLElement;
import org.newdawn.slick.util.xml.XMLElementList;

public class EntityLoader {
    private AssetStore<EntityDescriptor> entityDescriptors = new AssetStore();
    private AssetStore<Constructor<? extends Entity>> typeConstructors = new AssetStore();
    private AssetStore<String> entityTypes = new AssetStore();
    private AssetStore<SpriteSheet> spriteSheets = new AssetStore();
    private AssetStore<Animation> animations = new AssetStore();
    private AssetStore<Audio> sounds = new AssetStore();
    private AssetStore<ConfigurableEmitter> emitters = new AssetStore();
    private AssetStore<BoundingBox> boundingBoxes = new AssetStore();

    public EntityLoader(String path) {
        try {
            this.loadEntityTypes(path + File.separator + "types.xml");
            this.loadSpriteSheets(path + File.separator + "spritesheets.xml");
            this.loadAnimations(path + File.separator + "animations.xml");
            this.loadSounds(path + File.separator + "sounds.xml");
            this.loadParticleEmitters(path + File.separator + "particleemitters.xml");
            this.loadBoundingBoxes(path + File.separator + "boundingboxes.xml");
            this.loadEntities(path + File.separator + "entities.xml");
        }
        catch (SlickException e) {
            throw new LoaderException("Asset loading could not be completed.", e);
        }
    }

    public Entity create(String name) {
        String type = this.entityTypes.get(name);
        Constructor<? extends Entity> constructor = this.typeConstructors.get(type);
        EntityDescriptor descriptor = this.entityDescriptors.get(name);
        if (constructor == null) {
            throw new LoaderException("No entity type is named '" + name + "'");
        }
        try {
            return constructor.newInstance(descriptor);
        }
        catch (InstantiationException e) {
            throw new LoaderException("Could not instantiate abstract entity of type '" + type + "' for '" + name + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new LoaderException("Could not access the requested constructor of '" + type + "' for '" + name + "'.", e);
        }
        catch (IllegalArgumentException e) {
            throw new LoaderException("Entity constructor of '" + type + "' requires unexpected arguments for '" + name + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new LoaderException("Entity constructor of '" + type + "' caused an exception for '" + name + "'.", e);
        }
        catch (ExceptionInInitializerError e) {
            throw new LoaderException("Failed to initialize entity type '" + type + "' for '" + name + "'.", e);
        }
    }

    private void loadEntities(String file) throws SlickException {
        new AssetXMLLoader(file, "entities", "entity", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                String type = node.getAttribute("type");
                if (!EntityLoader.this.typeConstructors.contains(type)) {
                    throw new SlickException("The entity '" + name + "' refers to the type '" + type + "', which does not exist.");
                }
                EntityLoader.this.entityTypes.add(name, type);
                EntityDescriptor descriptor = new EntityDescriptor();
                XMLElementList childNodeList = node.getChildren();
                for (int i = 0; i < childNodeList.size(); ++i) {
                    int j;
                    XMLElement childNode = childNodeList.get(i);
                    if (childNode.getName().equals("animations")) {
                        XMLElementList animationNodeList = childNode.getChildrenByName("animation");
                        for (j = 0; j < animationNodeList.size(); ++j) {
                            XMLElement animationNode = animationNodeList.get(j);
                            String animationName = animationNode.getAttribute("name");
                            String animationReference = animationNode.getAttribute("reference");
                            if (!EntityLoader.this.animations.contains(animationReference)) {
                                throw new SlickException("Entity '" + name + "' referenced the " + "animation '" + animationReference + "', which does not exist.");
                            }
                            descriptor.animations.add(animationName, (Animation)EntityLoader.this.animations.get(animationReference));
                        }
                        continue;
                    }
                    if (childNode.getName().equals("sounds")) {
                        XMLElementList soundNodeList = childNode.getChildrenByName("sound");
                        for (j = 0; j < soundNodeList.size(); ++j) {
                            XMLElement soundNode = soundNodeList.get(j);
                            String soundName = soundNode.getAttribute("name");
                            String soundReference = soundNode.getAttribute("reference");
                            if (!EntityLoader.this.sounds.contains(soundReference)) {
                                throw new SlickException("Entity '" + name + "' referenced the " + "sound '" + soundReference + "', which does not exist.");
                            }
                            descriptor.sounds.add(soundName, (Audio)EntityLoader.this.sounds.get(soundReference));
                        }
                        continue;
                    }
                    if (childNode.getName().equals("boundingboxes")) {
                        XMLElementList boundingboxNodeList = childNode.getChildrenByName("boundingbox");
                        for (j = 0; j < boundingboxNodeList.size(); ++j) {
                            XMLElement boundingboxNode = boundingboxNodeList.get(j);
                            String boundingboxName = boundingboxNode.getAttribute("name");
                            String boundingboxReference = boundingboxNode.getAttribute("reference");
                            if (!EntityLoader.this.boundingBoxes.contains(boundingboxReference)) {
                                throw new SlickException("Entity '" + name + "' referenced the " + "bounding box '" + boundingboxReference + "', which does not exist.");
                            }
                            descriptor.boundingBoxes.add(boundingboxName, (BoundingBox)EntityLoader.this.boundingBoxes.get(boundingboxReference));
                        }
                        continue;
                    }
                    if (childNode.getName().equals("particleemitters")) {
                        XMLElementList particleemitterNodeList = childNode.getChildrenByName("particleemitter");
                        for (j = 0; j < particleemitterNodeList.size(); ++j) {
                            XMLElement particleemitterNode = particleemitterNodeList.get(j);
                            String particleemitterName = particleemitterNode.getAttribute("name");
                            String particleemitterReference = particleemitterNode.getAttribute("reference");
                            if (!EntityLoader.this.emitters.contains(particleemitterReference)) {
                                throw new SlickException("Entity '" + name + "' referenced the " + "particle emitter '" + particleemitterReference + "', which does not exist.");
                            }
                            descriptor.particleEmitters.add(particleemitterName, (ConfigurableEmitter)EntityLoader.this.emitters.get(particleemitterReference));
                        }
                        continue;
                    }
                    if (childNode.getName().equals("properties")) {
                        XMLElementList propertyNodeList = childNode.getChildrenByName("property");
                        for (j = 0; j < propertyNodeList.size(); ++j) {
                            XMLElement propertyNode = propertyNodeList.get(j);
                            String key = propertyNode.getAttribute("key");
                            String value = propertyNode.getAttribute("value");
                            descriptor.properties.add(key, value);
                        }
                        continue;
                    }
                    throw new SlickXMLException("Invalid entity child node '" + childNode.getName() + "' for '" + name + "'. " + "Expecting one of animations, sounds, boundingboxes, " + "particleemitters or properties.");
                }
                EntityLoader.this.entityDescriptors.add(name, descriptor);
            }
        });
    }

    private void loadBoundingBoxes(String file) throws SlickException {
        new AssetXMLLoader(file, "boundingboxes", "boundingbox", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                float x = (float)node.getDoubleAttribute("x");
                float y = (float)node.getDoubleAttribute("y");
                float w = (float)node.getDoubleAttribute("width");
                float h = (float)node.getDoubleAttribute("height");
                EntityLoader.this.boundingBoxes.add(name, new BoundingBox(x, y, w, h));
            }
        });
    }

    private void loadParticleEmitters(String file) throws SlickException {
        new AssetXMLLoader(file, "particleemitters", "particleemitter", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                String confFile = node.getAttribute("conffile");
                try {
                    ConfigurableEmitter emitter = ParticleIO.loadEmitter(this.getClass().getResourceAsStream(confFile));
                    XMLElementList settingNodeList = node.getChildren();
                    for (int i = 0; i < settingNodeList.size(); ++i) {
                        XMLElement settingNode = settingNodeList.get(i);
                        if (settingNode.getName().equals("particleimage")) {
                            emitter.setImageName(settingNode.getAttribute("img"));
                            continue;
                        }
                        if (settingNode.getName().equals("colors")) {
                            ArrayList<ConfigurableEmitter.ColorRecord> colors = new ArrayList<ConfigurableEmitter.ColorRecord>();
                            XMLElementList colorNodeList = settingNode.getChildren();
                            for (int j = 0; j < colorNodeList.size(); ++j) {
                                XMLElement colorNode = colorNodeList.get(j);
                                if (!colorNode.getName().equals("color")) {
                                    throw new SlickXMLException("Invalid node '" + colorNode.getName() + "' for '" + name + "'. " + "Expecting a 'color' node.");
                                }
                                float pos = (float)colorNode.getDoubleAttribute("pos");
                                float r = (float)colorNode.getDoubleAttribute("r");
                                float g = (float)colorNode.getDoubleAttribute("g");
                                float b = (float)colorNode.getDoubleAttribute("b");
                                ConfigurableEmitter configurableEmitter = emitter;
                                configurableEmitter.getClass();
                                colors.add(new ConfigurableEmitter.ColorRecord(configurableEmitter, pos, new Color(r, g, b)));
                            }
                            emitter.colors = colors;
                            continue;
                        }
                        throw new SlickXMLException("Invalid emitter setting node '" + settingNode.getName() + "' for '" + name + "'. " + "Expecting particleimage or colors.");
                    }
                    EntityLoader.this.emitters.add(name, emitter);
                }
                catch (IOException e) {
                    throw new SlickException("Failed to load particle emitter configuration file for '" + name + "'.", e);
                }
            }
        });
    }

    private void loadSounds(String file) throws SlickException {
        new AssetXMLLoader(file, "sounds", "sound", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                String file = node.getAttribute("file");
                BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(file));
                try {
                    EntityLoader.this.sounds.add(name, AudioLoader.getAudio("WAV", in));
                }
                catch (IOException e) {
                    throw new SlickException("Failed to load sound " + name + ".", e);
                }
            }
        });
    }

    private void loadAnimations(String file) throws SlickException {
        new AssetXMLLoader(file, "animations", "animation", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                boolean loop = node.getBooleanAttribute("loop", true);
                String spriteSheet = null;
                int[] indices = new int[]{};
                int[] durations = new int[]{};
                XMLElementList childNodeList = node.getChildren();
                for (int i = 0; i < childNodeList.size(); ++i) {
                    XMLElement childNode = childNodeList.get(i);
                    if (childNode.getName().equals("spritesheet")) {
                        spriteSheet = childNode.getAttribute("name");
                        continue;
                    }
                    if (childNode.getName().equals("frames")) {
                        XMLElementList frameNodeList = childNode.getChildrenByName("frame");
                        indices = new int[2 * frameNodeList.size()];
                        durations = new int[frameNodeList.size()];
                        for (int j = 0; j < frameNodeList.size(); ++j) {
                            XMLElement frameNode = frameNodeList.get(j);
                            indices[2 * j + 0] = frameNode.getIntAttribute("x");
                            indices[2 * j + 1] = frameNode.getIntAttribute("y");
                            durations[j] = frameNode.getIntAttribute("length");
                        }
                        continue;
                    }
                    throw new SlickXMLException("Invalid animation child node '" + childNode.getName() + "' for '" + name + "'. Expecting spritesheet or frames.");
                }
                if (spriteSheet == null) {
                    throw new SlickXMLException("The animation '" + name + "' requires a sprite sheet.");
                }
                if (!EntityLoader.this.spriteSheets.contains(spriteSheet)) {
                    throw new SlickException("The animation '" + name + "' refers to the sprite sheet '" + spriteSheet + "', which does not exist.");
                }
                SpriteSheet sheet = (SpriteSheet)EntityLoader.this.spriteSheets.get(spriteSheet);
                Animation animation = new Animation(sheet, indices, durations);
                animation.setLooping(loop);
                EntityLoader.this.animations.add(name, animation);
            }
        });
    }

    private void loadSpriteSheets(String file) throws SlickException {
        new AssetXMLLoader(file, "spritesheets", "spritesheet", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                String file = null;
                int w = 32;
                int h = 32;
                int spacing = 0;
                int margin = 0;
                XMLElementList childNodeList = node.getChildren();
                for (int i = 0; i < childNodeList.size(); ++i) {
                    XMLElement childNode = childNodeList.get(i);
                    if (childNode.getName().equals("file")) {
                        file = childNode.getAttribute("path");
                        continue;
                    }
                    if (childNode.getName().equals("tile")) {
                        w = childNode.getIntAttribute("w", 32);
                        h = childNode.getIntAttribute("h", 32);
                        spacing = childNode.getIntAttribute("spacing", 0);
                        margin = childNode.getIntAttribute("margin", 0);
                        continue;
                    }
                    throw new SlickXMLException("Invalid sprite sheet node '" + childNode.getName() + " for '" + name + "''. Expecting file or tile.");
                }
                if (file == null) {
                    throw new SlickXMLException("A file node is required for sprite sheet '" + name + "'");
                }
                Image tmp = ImageUtil.load(file);
                EntityLoader.this.spriteSheets.add(name, new SpriteSheet(tmp, w, h, spacing, margin));
            }
        });
    }

    private void loadEntityTypes(String file) throws SlickException {
        new AssetXMLLoader(file, "types", "type", new AssetXMLLoader.Handler(){

            public void handle(XMLElement node) throws SlickException {
                String name = node.getAttribute("name");
                String className = node.getAttribute("class");
                try {
                    Class<?> clazz = Class.forName(className);
                    Class<Entity> entityClass = clazz.asSubclass(Entity.class);
                    Constructor<Entity> constructor = entityClass.getConstructor(EntityDescriptor.class);
                    EntityLoader.this.typeConstructors.add(name, constructor);
                }
                catch (ClassNotFoundException e) {
                    throw new SlickException("Could not load and initialize class '" + className + "' for '" + name + "'.", e);
                }
                catch (ClassCastException e) {
                    throw new SlickException("Entity types may only be subclasses of the " + Entity.class.getSimpleName() + " class for '" + name + "'.", e);
                }
                catch (ExceptionInInitializerError e) {
                    throw new SlickException("Failed to initialize entity class type for '" + name + "'.", e);
                }
                catch (LinkageError e) {
                    throw new SlickException("Linkage of entity class type failed for '" + name + "'.", e);
                }
                catch (NoSuchMethodException e) {
                    throw new SlickException("Entity classes must have a public constructor that take a EntityDescriptor argument for '" + name + "'.", e);
                }
                catch (SecurityException e) {
                    throw new SlickException("The constructor of entity classes must be public and accessible for '" + name + "'.", e);
                }
            }
        });
    }
}

