/*
 * Decompiled with CFR 0.152.
 */
package game.engine.loader;

import game.engine.loader.AssetStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyStore
extends AssetStore<String> {
    public int getInt(String name) {
        return Integer.parseInt((String)this.get(name));
    }

    public int getInt(String name, int def) {
        return Integer.parseInt(this.get(name, String.valueOf(def)));
    }

    public float getFloat(String name) {
        return Float.parseFloat((String)this.get(name));
    }

    public float getFloat(String name, float def) {
        return Float.parseFloat(this.get(name, String.valueOf(def)));
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean((String)this.get(name));
    }

    public boolean getInt(String name, boolean def) {
        return Boolean.parseBoolean(this.get(name, String.valueOf(def)));
    }

    public String[] getArray(String name) {
        String raw = (String)this.get(name);
        if (raw == null) {
            return null;
        }
        String[] ret = raw.split("\\s*,\\s*");
        return ret;
    }

    public String[] getArray(String name, String ... def) {
        String raw = (String)this.get(name);
        if (raw == null) {
            return def;
        }
        String[] ret = raw.split("\\s*,\\s*");
        return ret;
    }

    public int[] getIntArray(String name) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return null;
        }
        int[] ret = new int[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Integer.parseInt(raw[i]);
        }
        return ret;
    }

    public int[] getIntArray(String name, int ... def) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return def;
        }
        int[] ret = new int[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Integer.parseInt(raw[i]);
        }
        return ret;
    }

    public float[] getFloatArray(String name) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return null;
        }
        float[] ret = new float[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Float.parseFloat(raw[i]);
        }
        return ret;
    }

    public float[] getFloatArray(String name, float ... def) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return def;
        }
        float[] ret = new float[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Float.parseFloat(raw[i]);
        }
        return ret;
    }

    public boolean[] getBooleanArray(String name) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return null;
        }
        boolean[] ret = new boolean[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Boolean.parseBoolean(raw[i]);
        }
        return ret;
    }

    public boolean[] getBooleanArray(String name, boolean ... def) {
        String[] raw = this.getArray(name);
        if (raw == null) {
            return def;
        }
        boolean[] ret = new boolean[raw.length];
        for (int i = 0; i < raw.length; ++i) {
            ret[i] = Boolean.parseBoolean(raw[i]);
        }
        return ret;
    }
}

