/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Character;
import game.entities.Entity;
import game.entities.ParticleSystemEntity;
import game.entities.Player;
import game.entities.Projectile;
import game.entities.ProjectileGroup;
import game.entities.visitor.Visitor;
import game.map.NullBlockTester;
import game.world.GameWorld;
import java.util.ArrayList;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;

public class Boss
extends Character {
    private static final int STAR_COUNT = 10;
    private static final int CONE_SPREAD = 30;
    private static final int CONE_COUNT = 3;
    private static final int SHOOT_ANIMATION_PRE = 500;
    private static final int SHOOT_ANIMATION_POST = 200;
    private static final int SHOT_POOL_SIZE = 50;
    private BossState bossState;
    private int shootCooldown;
    private Projectile[] shots;
    private int nextShot;

    public Boss(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "idle";
        this.bossState = BossState.idle;
        this.shootCooldown = 0;
        this.nextShot = 0;
        this.health = BossState.idle.healthLimit;
        this.shots = null;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        if (this.shots == null) {
            this.shots = new Projectile[50];
            for (int i = 0; i < this.shots.length; ++i) {
                this.shots[i] = (Projectile)world.getLoader().create("gooball");
            }
        }
        if (this.bossState == BossState.idle && this.canSeePlayer(world) || this.health < this.bossState.healthLimit) {
            this.playAudio(this.bossState.audio);
            this.bossState = this.bossState.next();
        } else if (this.bossState.shootType != ShootType.none) {
            this.shootCooldown -= dt;
            if (this.currentState.equals(this.bossState.defaultState) && this.shootCooldown <= 500) {
                this.currentState = "shoot";
                for (Animation a : (ArrayList)this.stateMap.get(this.currentState)) {
                    a.restart();
                }
            } else if (this.currentState.equals("shoot") && this.shootCooldown <= 0) {
                ProjectileGroup group = new ProjectileGroup();
                if (this.bossState.shootType == ShootType.single) {
                    Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                    Vector2f sd = this.getDirectionTo(world.getPlayer());
                    this.shoot(world, sp, sd, group);
                } else if (this.bossState.shootType == ShootType.cone) {
                    for (int i = 0; i < 3; ++i) {
                        Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                        Vector2f sd = this.getDirectionTo(world.getPlayer());
                        sd.add(world.getRandom().nextInt(30) - 15);
                        this.shoot(world, sp, sd, group);
                    }
                } else if (this.bossState.shootType == ShootType.star) {
                    for (int i = 0; i < 10; ++i) {
                        Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                        Vector2f sd = this.getDirectionTo(world.getPlayer());
                        sd.add(36 * i + world.getRandom().nextInt(36) - 18);
                        this.shoot(world, sp, sd, group);
                    }
                }
                this.playAudio(this.bossState.shootType.audio);
                this.shootCooldown += this.bossState.cooldown + 200;
            } else if (this.currentState.equals("shoot") && this.shootCooldown > 500 && this.shootCooldown <= this.bossState.cooldown) {
                this.currentState = this.bossState.defaultState;
            }
        } else {
            this.currentState = this.bossState.defaultState;
        }
    }

    private boolean canSeePlayer(GameWorld world) {
        Player p = world.getPlayer();
        BoundingBox pb = p.getBoundingBox();
        Vector2f pp = p.getPos();
        BoundingBox bb = this.getBoundingBox();
        Vector2f bp = this.getPos();
        Line lineOfSight = new Line(pb.getCenterX(pp), pb.getCenterY(pp), bb.getCenterX(bp), bb.getCenterY(bp));
        return !world.getMap().isBlocked(lineOfSight, new NullBlockTester());
    }

    private void shoot(GameWorld world, Vector2f sp, Vector2f sd, ProjectileGroup group) {
        Projectile shot = this.shots[this.nextShot];
        shot.reinit(sp, sd, Projectile.Target.player);
        shot.setGroup(group);
        if (!world.getEntities().get().contains(shot)) {
            world.getEntities().add(shot);
        }
        this.nextShot = (this.nextShot + 1) % this.shots.length;
    }

    private Vector2f getShotPosition(BoundingBox shotBoundingBox) {
        return new Vector2f(this.getActualBox().getCenterX(this.getPos()) - shotBoundingBox.getCenterX(0.0f, 0.0f), this.getActualBox().getCenterY(this.getPos()) - shotBoundingBox.getCenterY(0.0f, 0.0f));
    }

    private Vector2f getDirectionTo(Entity gameObject) {
        Vector2f pp = gameObject.getPos();
        BoundingBox pb = gameObject.getActualBox();
        Vector2f shotDir = new Vector2f(pb.getCenterX(pp) - this.getActualBox().getCenterX(this.getPos()), pb.getCenterY(pp) - this.getActualBox().getCenterY(this.getPos()));
        shotDir.normalise();
        return shotDir;
    }

    public boolean isSolidBlocking() {
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    protected void onDeath(GameWorld world) {
        if (this.bossState != BossState.dead) {
            ConfigurableEmitter deathEmitter = ((ConfigurableEmitter)this.emitters.get("death")).duplicate();
            deathEmitter.setPosition(this.pos.x, this.pos.y);
            world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(deathEmitter);
            this.currentState = "death";
            this.bossState = BossState.dead;
        }
    }

    protected void onDamaged(GameWorld world, Vector2f projectileDirection) {
        ConfigurableEmitter shotEmitter = ((ConfigurableEmitter)this.emitters.get("shot")).duplicate();
        shotEmitter.setPosition(this.getActualBox().getCenterX(this.pos), this.getActualBox().getCenterY(this.pos));
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)shotEmitter.angularOffset;
        val.setValue((float)projectileDirection.getTheta() + 270.0f);
        shotEmitter.angularOffset = val;
        world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(shotEmitter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BossState {
        idle(0, ShootType.none, 3000, "idle", "activate"),
        active(3000, ShootType.single, 2000, "idle", "roar"),
        angry(2000, ShootType.cone, 1000, "idle", "roar"),
        desperate(2000, ShootType.star, 0, "idle", "die"),
        dead(0, ShootType.none, Integer.MIN_VALUE, "death", null);

        public final int cooldown;
        public final ShootType shootType;
        public final int healthLimit;
        public final String defaultState;
        public final String audio;

        private BossState(int cooldown, ShootType shootType, int healthLimit, String defaultState, String audio) {
            this.cooldown = cooldown;
            this.shootType = shootType;
            this.healthLimit = healthLimit;
            this.defaultState = defaultState;
            this.audio = audio;
        }

        public BossState next() {
            return BossState.values()[Math.min(this.ordinal() + 1, BossState.values().length)];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShootType {
        none(null),
        single("single"),
        cone("cone"),
        star("star");

        public final String audio;

        private ShootType(String audio) {
            this.audio = audio;
        }
    }
}

