/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Moveable;
import game.entities.ParticleSystemEntity;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;

public abstract class Character
extends Moveable {
    public static final int MAX_HEALTH = 100;
    protected int health = 100;
    private boolean isBeingKnockedBack;
    private static final float NPC_KNOCKBACK_SPEED = 0.3f;
    private static final int NPC_KNOCKBACK_DURATION = 100;
    private int knockBackTicker;
    private Vector2f knockBackDirection;

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.isBeingKnockedBack) {
            this.move(this.pos.copy().add(this.knockBackDirection.copy().scale(dt)), world, true, false);
            this.knockBackTicker += dt;
            if (this.knockBackTicker > 100) {
                this.knockBackTicker = 0;
                this.isBeingKnockedBack = false;
            }
        }
    }

    public Character(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void takeDMG(GameWorld world, int dmg, Vector2f projectileDirection) {
        this.health -= dmg;
        if (this.health <= 0) {
            this.health = 0;
            this.onDeath(world);
        } else {
            this.onDamaged(world, projectileDirection);
        }
    }

    protected void onDamaged(GameWorld world, Vector2f projectileDirection) {
        ConfigurableEmitter shotEmitter = ((ConfigurableEmitter)this.emitters.get("shot")).duplicate();
        shotEmitter.setPosition(this.pos.x, this.pos.y);
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)shotEmitter.angularOffset;
        val.setValue((float)projectileDirection.getTheta() + 270.0f);
        shotEmitter.angularOffset = val;
        world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(shotEmitter);
    }

    protected void onDeath(GameWorld world) {
        ConfigurableEmitter deathEmitter = ((ConfigurableEmitter)this.emitters.get("death")).duplicate();
        deathEmitter.setPosition(this.pos.x, this.pos.y);
        world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(deathEmitter);
        world.getEntities().remove(this);
    }

    public boolean isDead() {
        return this.health <= 0;
    }

    public int getHealth() {
        return this.health;
    }

    public void knockback(Vector2f direction) {
        this.isBeingKnockedBack = true;
        direction = direction.normalise();
        this.knockBackDirection = new Vector2f(direction.x * 0.3f, direction.y * 0.3f);
    }
}

