/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.AssetEntry;
import game.engine.loader.AssetStore;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.PropertyStore;
import game.entities.Projectile;
import game.entities.visitor.Visitor;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

public abstract class Entity {
    private static final int RENDER_BIN_ENTITY = 0;
    private final int renderBin;
    protected Vector2f pos = new Vector2f(0.0f, 0.0f);
    protected BoundingBox bbMovement;
    protected BoundingBox bbCollision;
    protected BoundingBox bbActual;
    protected HashMap<String, ArrayList<Animation>> stateMap;
    protected String currentState;
    protected AssetStore<ConfigurableEmitter> emitters;
    protected AssetStore<Audio> audioMap;
    protected PropertyStore propertyMap;

    public Entity(EntityDescriptor descriptor) {
        this.renderBin = 0;
        this.bbMovement = descriptor.boundingBoxes.get("movement");
        this.bbCollision = descriptor.boundingBoxes.get("collision");
        this.bbActual = descriptor.boundingBoxes.get("actual");
        this.stateMap = new HashMap();
        for (AssetEntry<Animation> assetEntry : descriptor.animations) {
            ArrayList<Animation> animations = new ArrayList<Animation>();
            animations.add(assetEntry.getAsset().copy());
            this.stateMap.put(assetEntry.getId(), animations);
        }
        this.currentState = "default";
        this.emitters = descriptor.particleEmitters;
        this.audioMap = descriptor.sounds;
        this.propertyMap = descriptor.properties;
    }

    public Vector2f getPos() {
        return this.pos;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
    }

    public int compareRenderOrder(Entity other) {
        int mpa = 0;
        int mpb = 0;
        if (this instanceof Projectile && ((Projectile)this).isMoving()) {
            mpa = 1;
        } else if (other instanceof Projectile && ((Projectile)other).isMoving()) {
            mpb = 1;
        }
        if (mpa == mpb) {
            Vector2f pa = this.getPos();
            Vector2f pb = other.getPos();
            return Float.compare(this.getBoundingBox().getCenterY(pa), other.getBoundingBox().getCenterY(pb));
        }
        return Integer.valueOf(mpa).compareTo(mpb);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        if (this.stateMap.containsKey(this.currentState)) {
            BoundingBox screenBounds = world.getCamera().getScreenBounds();
            if (this.getBoundingBox().intersects(this.pos, screenBounds, world.getCamera().getScreenPos())) {
                g.translate(this.pos.x, this.pos.y);
                return true;
            }
            return false;
        }
        return false;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        ArrayList<Animation> animationStack = this.stateMap.get(this.currentState);
        if (animationStack != null) {
            for (int i = 0; i < animationStack.size(); ++i) {
                g.drawAnimation(animationStack.get(i), 0.0f, 0.0f);
            }
        }
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
        g.translate(-this.pos.x, -this.pos.y);
    }

    public BoundingBox getBoundingBox() {
        return this.bbMovement;
    }

    public BoundingBox getCollisionBox() {
        return this.bbCollision;
    }

    public BoundingBox getActualBox() {
        return this.bbActual;
    }

    public void setPos(float x, float y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public void playAudio(String name) {
        this.audioMap.get(name).playAsSoundEffect(1.0f, 1.0f, false);
    }

    public String getProperty(String key, String def) {
        String value = (String)this.propertyMap.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public abstract void accept(Visitor var1);

    public boolean isSolidBlocking() {
        return false;
    }
}

