/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.visitor.Visitor;
import game.world.GameWorld;
import java.util.ArrayList;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public abstract class GameDoor
extends Entity {
    protected static final int DOOR_STATES = 5;
    private boolean opened = false;
    private int openState = 0;

    public GameDoor(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean isSolidBlocking() {
        return !this.opened;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        if (!this.opened) {
            ArrayList animationStack = (ArrayList)this.stateMap.get(this.currentState);
            for (Animation animation : animationStack) {
                g.drawImage(animation.getImage(this.openState), 0.0f, 0.0f);
            }
        }
    }

    protected void lower() {
        if (!this.opened) {
            ++this.openState;
            if (this.openState > 4) {
                this.openState = 4;
                this.open();
            } else {
                this.playAudio("move");
            }
        }
    }

    protected void open() {
        if (!this.opened) {
            this.opened = true;
            this.openState = 4;
            this.playAudio("open");
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getOpenState() {
        return this.openState;
    }
}

