/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.map.GameMap;
import game.world.GameWorld;
import java.util.List;
import org.newdawn.slick.geom.Vector2f;

public abstract class Moveable
extends Entity {
    protected Vector2f forward = new Vector2f(1.0f, 0.0f);

    public Moveable(EntityDescriptor descriptor) {
        super(descriptor);
    }

    protected boolean move(Vector2f toWhere, GameWorld world, boolean worldCollision, boolean objectCollision) {
        GameMap map;
        if (worldCollision && (map = world.getMap()).isBlocked(this.getBoundingBox(), toWhere)) {
            return false;
        }
        if (worldCollision || objectCollision) {
            List<Entity> objs = world.getEntities().get();
            for (Entity obj : objs) {
                if (obj == this || (!obj.isSolidBlocking() || !worldCollision) && !objectCollision || !this.getBoundingBox().intersects(toWhere, obj.getBoundingBox(), obj.getPos())) continue;
                return false;
            }
        }
        this.pos = toWhere.copy();
        return true;
    }

    public Vector2f getForward() {
        return this.forward;
    }
}

