/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.NPC;
import game.entities.visitor.Visitor;
import game.world.GameWorld;
import java.util.Set;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class NightmareSpawner
extends Entity {
    private static final int TIME_UNIT = 3000;
    private static final int CREATE_PER_TIME_UNIT = 7;
    private static final int MIN_SPAWN_PER_TIME_UNIT = 3;
    private static final float SPAWN_PERCENTAGE = 0.08f;
    private static final int MAX_STORED_NIGHTMARES = 100;
    private int storedNightmares = 50;
    private boolean connectedToSocket;
    private int tick;

    public NightmareSpawner(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        if (world.getPlayer().getSocket() == null && this.connectedToSocket) {
            this.connectedToSocket = false;
            this.tick = 0;
        } else if (world.getPlayer().getSocket() != null && !this.connectedToSocket) {
            this.connectedToSocket = true;
            this.tick = 0;
        }
        this.tick += dt;
        if (this.tick >= 3000) {
            this.tick = 0;
            if (this.connectedToSocket) {
                this.updateConnected(world);
            } else {
                this.updateDisconnected();
            }
        }
    }

    private void updateDisconnected() {
        if (this.storedNightmares < 100) {
            this.storedNightmares += 7;
        }
    }

    private void updateConnected(GameWorld world) {
        if (this.storedNightmares <= 0) {
            return;
        }
        int spawnNbr = (int)((float)this.storedNightmares * 0.08f);
        spawnNbr = Math.max(spawnNbr, 3);
        this.storedNightmares -= spawnNbr;
        if (this.storedNightmares < 0) {
            this.storedNightmares = 0;
        }
        Vector2f playerPos = world.getPlayer().getPos();
        GameCamera camera = world.getCamera();
        BoundingBox screenBounds = camera.getScreenBounds();
        Vector2f screenPos = camera.getScreenPos();
        Set<Vector2f> spawnLocations = world.getMap().findSpawnablePositions(playerPos, screenBounds, screenPos, spawnNbr, world);
        NPC.NPCTypes[] npcTypeValues = NPC.NPCTypes.values();
        int nbrTypes = npcTypeValues.length;
        int currType = 0;
        for (Vector2f loc : spawnLocations) {
            NPC newEnemy = (NPC)world.getLoader().create(npcTypeValues[currType++].name());
            newEnemy.setPos(loc.x, loc.y);
            world.getEntities().add(newEnemy);
            currType %= nbrTypes;
        }
    }

    public void accept(Visitor visitor) {
    }
}

