/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.engine.util.ImageUtil;
import game.entities.Entity;
import game.entities.visitor.Visitor;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.particles.ParticleSystem;

public class ParticleSystemEntity
extends Entity {
    private ParticleSystem particleSystem;

    public ParticleSystemEntity(EntityDescriptor descriptor) {
        super(descriptor);
        try {
            this.particleSystem = new ParticleSystem(ImageUtil.load("/assets/graphics/ribs.png"), 250);
        }
        catch (SlickException e) {
            throw new RuntimeException(e);
        }
        this.particleSystem.setRemoveCompletedEmitters(true);
        this.particleSystem.setBlendingMode(2);
    }

    public ParticleSystem getSystem() {
        return this.particleSystem;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.particleSystem.update(dt);
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        return true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.particleSystem.render();
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
    }

    public void accept(Visitor visitor) {
    }
}

