/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Character;
import game.entities.ParticleSystemEntity;
import game.entities.Projectile;
import game.entities.WallSocket;
import game.entities.visitor.Visitor;
import game.world.GameWorld;
import java.util.List;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Input;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;

public class Player
extends Character {
    private static final int SHOT_POOL_SIZE = 100;
    protected static float SPEED = 0.1f;
    private static final int REGEN_PER_HAPPY_THOUGHT = 2;
    protected boolean idle = true;
    protected boolean hasWon;
    protected WallSocket socket;
    protected State state = State.idle_east;
    private int lastKey;
    private Projectile[] shots;
    private int nextShot;

    public Player(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = this.state.name();
        this.socket = null;
        this.lastKey = 157;
        this.nextShot = 0;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        BoundingBox goal;
        Input input;
        super.update(dt, world, container);
        if (this.shots == null) {
            this.shots = new Projectile[100];
            int projectileType = 0;
            Projectile.ProjectileTypes[] projectileTypeValues = Projectile.ProjectileTypes.values();
            int nbrProjectileTypes = projectileTypeValues.length - 1;
            for (int i = 0; i < this.shots.length - 1; ++i) {
                this.shots[i] = (Projectile)world.getLoader().create(projectileTypeValues[projectileType++].name());
                projectileType %= nbrProjectileTypes;
            }
            this.shots[this.shots.length - 1] = (Projectile)world.getLoader().create("greenpixel");
        }
        if ((input = container.getInput()).isKeyDown(17)) {
            this.forward.x = 0.0f;
            this.forward.y = -1.0f;
            this.setState(State.walk_north);
            this.idle = false;
        } else if (input.isKeyDown(31)) {
            this.forward.x = 0.0f;
            this.forward.y = 1.0f;
            this.setState(State.walk_south);
            this.idle = false;
        } else if (input.isKeyDown(30)) {
            this.forward.x = -1.0f;
            this.forward.y = 0.0f;
            this.setState(State.walk_west);
            this.idle = false;
        } else if (input.isKeyDown(32)) {
            this.forward.x = 1.0f;
            this.forward.y = 0.0f;
            this.setState(State.walk_east);
            this.idle = false;
        } else {
            if (!this.idle) {
                switch (this.state) {
                    case walk_north: {
                        this.setState(State.idle_north);
                        break;
                    }
                    case walk_south: {
                        this.setState(State.idle_south);
                        break;
                    }
                    case walk_west: {
                        this.setState(State.idle_west);
                        break;
                    }
                    case walk_east: {
                        this.setState(State.idle_east);
                        break;
                    }
                    default: {
                        this.setState(State.idle_east);
                    }
                }
            }
            this.idle = true;
        }
        if (input.isKeyPressed(18)) {
            this.connectWallSocket(world);
        }
        boolean hasFired = false;
        boolean rc = false;
        boolean sp = false;
        boolean lc = false;
        while ((rc = input.isKeyPressed(157)) || (sp = input.isKeyPressed(57)) || (lc = input.isKeyPressed(29))) {
            if (rc && this.lastKey != 157) {
                this.lastKey = 157;
                continue;
            }
            if (sp && this.lastKey != 57) {
                this.lastKey = 57;
                continue;
            }
            if (lc && this.lastKey != 29) {
                this.lastKey = 29;
                continue;
            }
            if (!hasFired) {
                this.fire(world);
            }
            hasFired = true;
        }
        if (!this.idle) {
            float moveAmount = SPEED * (float)dt;
            this.move(new Vector2f(this.pos.x + this.forward.x * moveAmount, this.pos.y + this.forward.y * moveAmount), world, true, false);
        }
        if ((goal = world.getMap().getGoalBounds()).contains(0.0f, 0.0f, this.pos.x, this.pos.y)) {
            this.hasWon = true;
        }
    }

    public void setState(State state) {
        this.state = state;
        this.currentState = state.name();
    }

    private void connectWallSocket(GameWorld world) {
        if (this.socket != null) {
            this.socket.link(null);
            this.socket = null;
            this.playAudio("power_off");
            return;
        }
        List<WallSocket> sockets = world.getEntities().get(WallSocket.class);
        for (WallSocket s : sockets) {
            if (!this.getBoundingBox().intersects(this.getPos(), s.getCollisionBox(), s.getPos())) continue;
            this.socket = s;
            s.link(this);
            this.playAudio("power_on");
            return;
        }
    }

    private void fire(GameWorld world) {
        if (this.socket != null && this.socket.drain()) {
            this.spawnShot(world, new Vector2f(this.pos.x + 8.0f + this.forward.x * 8.0f, this.pos.y + 16.0f + this.forward.y * 8.0f), new Vector2f(this.forward.x, this.forward.y));
            this.playAudio("shoot");
        } else if (this.socket == null && this.health < 100) {
            this.health += 2;
            ConfigurableEmitter happyThoughtEmitter = ((ConfigurableEmitter)this.emitters.get("happythought")).duplicate();
            happyThoughtEmitter.setPosition(this.pos.x, this.pos.y);
            ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)happyThoughtEmitter.angularOffset;
            val.setValue((float)this.forward.getTheta() + 90.0f);
            happyThoughtEmitter.angularOffset = val;
            world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(happyThoughtEmitter);
            this.playAudio("happy");
        }
    }

    public void spawnShot(GameWorld world, Vector2f pos, Vector2f dir) {
        Projectile pew = this.shots[this.nextShot];
        this.nextShot = (this.nextShot + 1) % this.shots.length;
        pew.reinit(pos, dir, Projectile.Target.enemy);
        if (!world.getEntities().get().contains(pew)) {
            world.getEntities().add(pew);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public WallSocket getSocket() {
        return this.socket;
    }

    public void detach(GameWorld world) {
        this.connectWallSocket(world);
    }

    protected void onDeath(GameWorld world) {
        ConfigurableEmitter deathEmitter = ((ConfigurableEmitter)this.emitters.get("death")).duplicate();
        deathEmitter.setPosition(this.pos.x, this.pos.y);
        world.getEntities().getOne(ParticleSystemEntity.class).getSystem().addEmitter(deathEmitter);
    }

    public boolean hasWon() {
        return this.hasWon;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        walk_north,
        walk_south,
        walk_west,
        walk_east,
        idle_north,
        idle_south,
        idle_west,
        idle_east;

    }
}

