/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.GameDoor;
import game.entities.WallSocket;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;

public class TimedDoor
extends GameDoor {
    protected static final int DOOR_OPEN_TIME = 15000;
    private WallSocket socket = null;
    private int maxOpenTime;
    private int openTime = this.maxOpenTime = 15000;

    public TimedDoor(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void setSocket(WallSocket socket) {
        this.socket = socket;
    }

    public void setDoorTimer(int newTime) {
        this.openTime = newTime;
        this.maxOpenTime = newTime;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        if (!this.isOpened() && this.socket != null && this.socket.isConnected()) {
            this.openTime -= dt;
            int ds = this.maxOpenTime / 5;
            int state = Math.max(0, Math.min((this.maxOpenTime - this.openTime) / ds, 4));
            if (this.openTime <= 0) {
                this.open();
            } else if (state != this.getOpenState()) {
                this.lower();
            }
        }
    }
}

