/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.Character;
import game.objects.GameObject;
import game.objects.Player;
import game.objects.Projectile;
import game.objects.ProjectileGroup;
import game.objects.visitor.Visitor;
import game.world.NullBlockTester;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Boss
extends Character {
    private static final int STAR_COUNT = 10;
    private static final int CONE_SPREAD = 30;
    private static final int CONE_COUNT = 3;
    private static final int SHOOT_ANIMATION_PRE = 500;
    private static final int SHOOT_ANIMATION_POST = 200;
    private static final int SHOT_POOL_SIZE = 50;
    private BossState bossState;
    private int shootCooldown;
    private Projectile[] shots;
    private int nextShot;

    public Boss(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
        this.currentState = "idle";
        this.bossState = BossState.idle;
        this.shootCooldown = 0;
        this.shots = new Projectile[50];
        this.nextShot = 0;
        this.health = BossState.idle.healthLimit;
    }

    @Override
    public void init(MolyJamGame jam, GameContainer container) {
        super.init(jam, container);
        for (int i = 0; i < this.shots.length; ++i) {
            this.shots[i] = (Projectile)jam.getObjectLoader().createObject("gooball");
        }
    }

    @Override
    public GameObject clone() {
        return new Boss(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        if (this.bossState == BossState.idle && this.canSeePlayer(jam) || this.health < this.bossState.healthLimit) {
            this.playAudio(this.bossState.audio);
            this.bossState = this.bossState.next();
        } else if (this.bossState.shootType != ShootType.none) {
            this.shootCooldown -= dt;
            if (this.currentState.equals(this.bossState.defaultState) && this.shootCooldown <= 500) {
                this.currentState = "shoot";
                for (Animation a : (ArrayList)this.stateMap.get(this.currentState)) {
                    a.restart();
                }
            } else if (this.currentState.equals("shoot") && this.shootCooldown <= 0) {
                ProjectileGroup group = new ProjectileGroup();
                if (this.bossState.shootType == ShootType.single) {
                    Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                    Vector2f sd = this.getDirectionTo(jam.getPlayer());
                    this.shoot(jam, sp, sd, group);
                } else if (this.bossState.shootType == ShootType.cone) {
                    for (int i = 0; i < 3; ++i) {
                        Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                        Vector2f sd = this.getDirectionTo(jam.getPlayer());
                        sd.add(jam.getRandom().nextInt(30) - 15);
                        this.shoot(jam, sp, sd, group);
                    }
                } else if (this.bossState.shootType == ShootType.star) {
                    for (int i = 0; i < 10; ++i) {
                        Vector2f sp = this.getShotPosition(this.shots[0].getActualBox());
                        Vector2f sd = this.getDirectionTo(jam.getPlayer());
                        sd.add(36 * i + jam.getRandom().nextInt(36) - 18);
                        this.shoot(jam, sp, sd, group);
                    }
                }
                this.playAudio(this.bossState.shootType.audio);
                this.shootCooldown += this.bossState.cooldown + 200;
            } else if (this.currentState.equals("shoot") && this.shootCooldown > 500 && this.shootCooldown <= this.bossState.cooldown) {
                this.currentState = this.bossState.defaultState;
            }
        } else {
            this.currentState = this.bossState.defaultState;
        }
    }

    private boolean canSeePlayer(MolyJamGame jam) {
        Player p = jam.getPlayer();
        BoundingBox pb = p.getBoundingBox();
        Vector2f pp = p.getPos();
        BoundingBox bb = this.getBoundingBox();
        Vector2f bp = this.getPos();
        Line lineOfSight = new Line(pb.getCenterX(pp), pb.getCenterY(pp), bb.getCenterX(bp), bb.getCenterY(bp));
        return !jam.getWorld().isBlocked(lineOfSight, new NullBlockTester());
    }

    private void shoot(MolyJamGame jam, Vector2f sp, Vector2f sd, ProjectileGroup group) {
        Projectile shot = this.shots[this.nextShot];
        shot.reinit(sp, sd, Projectile.Target.player);
        shot.setGroup(group);
        if (!jam.getGameObjects().contains(shot)) {
            jam.addGameObject(shot);
        }
        this.nextShot = (this.nextShot + 1) % this.shots.length;
    }

    private Vector2f getShotPosition(BoundingBox shotBoundingBox) {
        return new Vector2f(this.getActualBox().getCenterX(this.getPos()) - shotBoundingBox.getCenterX(0.0f, 0.0f), this.getActualBox().getCenterY(this.getPos()) - shotBoundingBox.getCenterY(0.0f, 0.0f));
    }

    private Vector2f getDirectionTo(GameObject gameObject) {
        Vector2f pp = this.jam.getPlayer().getPos();
        BoundingBox pb = this.jam.getPlayer().getActualBox();
        Vector2f shotDir = new Vector2f(pb.getCenterX(pp) - this.getActualBox().getCenterX(this.getPos()), pb.getCenterY(pp) - this.getActualBox().getCenterY(this.getPos()));
        shotDir.normalise();
        return shotDir;
    }

    @Override
    public boolean isSolidBlocking() {
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void onDeath() {
        if (this.bossState != BossState.dead) {
            ConfigurableEmitter deathEmitter = ((ConfigurableEmitter)this.emitters.get("death")).duplicate();
            deathEmitter.setPosition(this.pos.x, this.pos.y);
            this.jam.getParticleSystem().addEmitter(deathEmitter);
            this.currentState = "death";
            this.bossState = BossState.dead;
        }
    }

    @Override
    protected void onDamaged(Vector2f projectileDirection) {
        ConfigurableEmitter shotEmitter = ((ConfigurableEmitter)this.emitters.get("shot")).duplicate();
        shotEmitter.setPosition(this.getActualBox().getCenterX(this.pos), this.getActualBox().getCenterY(this.pos));
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)shotEmitter.angularOffset;
        val.setValue((float)projectileDirection.getTheta() + 270.0f);
        shotEmitter.angularOffset = val;
        this.jam.getParticleSystem().addEmitter(shotEmitter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BossState {
        idle(0, ShootType.none, 3000, "idle", "activate"),
        active(3000, ShootType.single, 2000, "idle", "roar"),
        angry(2000, ShootType.cone, 1000, "idle", "roar"),
        desperate(2000, ShootType.star, 0, "idle", "die"),
        dead(0, ShootType.none, Integer.MIN_VALUE, "death", null);

        public final int cooldown;
        public final ShootType shootType;
        public final int healthLimit;
        public final String defaultState;
        public final String audio;

        private BossState(int cooldown, ShootType shootType, int healthLimit, String defaultState, String audio) {
            this.cooldown = cooldown;
            this.shootType = shootType;
            this.healthLimit = healthLimit;
            this.defaultState = defaultState;
            this.audio = audio;
        }

        public BossState next() {
            return BossState.values()[Math.min(this.ordinal() + 1, BossState.values().length)];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShootType {
        none(null),
        single("single"),
        cone("cone"),
        star("star");

        public final String audio;

        private ShootType(String audio) {
            this.audio = audio;
        }
    }
}

