/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.Moveable;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Character
extends Moveable {
    public static final int MAX_HEALTH = 100;
    protected int health = 100;
    private boolean isBeingKnockedBack;
    private static final float NPC_KNOCKBACK_SPEED = 0.3f;
    private static final int NPC_KNOCKBACK_DURATION = 100;
    private int knockBackTicker;
    private Vector2f knockBackDirection;

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        super.update(jam, container, dt);
        if (this.isBeingKnockedBack) {
            this.move(this.pos.copy().add(this.knockBackDirection.copy().scale(dt)), jam, true, false);
            this.knockBackTicker += dt;
            if (this.knockBackTicker > 100) {
                this.knockBackTicker = 0;
                this.isBeingKnockedBack = false;
            }
        }
    }

    public Character(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
    }

    public void takeDMG(int dmg, Vector2f projectileDirection) {
        this.health -= dmg;
        if (this.health <= 0) {
            this.health = 0;
            this.onDeath();
        } else {
            this.onDamaged(projectileDirection);
        }
    }

    protected void onDamaged(Vector2f projectileDirection) {
        ConfigurableEmitter shotEmitter = ((ConfigurableEmitter)this.emitters.get("shot")).duplicate();
        shotEmitter.setPosition(this.pos.x, this.pos.y);
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)shotEmitter.angularOffset;
        val.setValue((float)projectileDirection.getTheta() + 270.0f);
        shotEmitter.angularOffset = val;
        this.jam.getParticleSystem().addEmitter(shotEmitter);
    }

    protected void onDeath() {
        ConfigurableEmitter deathEmitter = ((ConfigurableEmitter)this.emitters.get("death")).duplicate();
        deathEmitter.setPosition(this.pos.x, this.pos.y);
        this.jam.getParticleSystem().addEmitter(deathEmitter);
        this.jam.despawn(this);
    }

    public boolean isDead() {
        return this.health <= 0;
    }

    public int getHealth() {
        return this.health;
    }

    public void knockback(Vector2f direction) {
        this.isBeingKnockedBack = true;
        direction = direction.normalise();
        this.knockBackDirection = new Vector2f(direction.x * 0.3f, direction.y * 0.3f);
    }
}

