/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.GameObject;
import game.objects.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GameDoor
extends GameObject {
    protected static final int DOOR_STATES = 5;
    private boolean opened = false;
    private int openState = 0;

    public GameDoor(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isSolidBlocking() {
        return !this.opened;
    }

    @Override
    public void render(MolyJamGame jam, GameContainer container, Graphics graphic) {
        if (!this.opened) {
            ArrayList animationStack = (ArrayList)this.stateMap.get(this.currentState);
            for (Animation animation : animationStack) {
                graphic.drawImage(animation.getImage(this.openState), 0.0f, 0.0f);
            }
        }
    }

    protected void lower() {
        if (!this.opened) {
            ++this.openState;
            if (this.openState > 4) {
                this.openState = 4;
                this.open();
            } else {
                this.playAudio("move");
            }
        }
    }

    protected void open() {
        if (!this.opened) {
            this.opened = true;
            this.openState = 4;
            this.playAudio("open");
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getOpenState() {
        return this.openState;
    }
}

