/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.engine.Updateable;
import game.objects.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GameObject
implements Updateable {
    protected Vector2f pos;
    protected MolyJamGame jam;
    protected BoundingBox bbMovement;
    protected BoundingBox bbCollision;
    protected BoundingBox bbActual;
    protected HashMap<String, ArrayList<Animation>> stateMap;
    protected String currentState;
    protected HashMap<String, ConfigurableEmitter> emitters;
    protected HashMap<String, Audio> audioMap;
    protected HashMap<String, String> propertyMap;

    public GameObject(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        HashMap sm = new HashMap();
        for (Map.Entry<String, ArrayList<Animation>> entry : stateMap.entrySet()) {
            ArrayList<Animation> animations = new ArrayList<Animation>();
            for (Animation a : entry.getValue()) {
                animations.add(a.copy());
            }
            sm.put(entry.getKey(), animations);
        }
        this.stateMap = sm;
        this.bbMovement = bbMovement;
        this.bbCollision = bbCollision;
        this.bbActual = bbActual;
        this.pos = new Vector2f(0.0f, 0.0f);
        this.currentState = "default";
        this.emitters = emitters;
        this.audioMap = audioMap;
        this.propertyMap = propertyMap;
    }

    public Vector2f getPos() {
        return this.pos;
    }

    @Override
    public void init(MolyJamGame jam, GameContainer container) {
        this.jam = jam;
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
    }

    @Override
    public void render(MolyJamGame jam, GameContainer container, Graphics graphic) {
        ArrayList<Animation> animationStack = this.stateMap.get(this.currentState);
        for (int i = 0; i < animationStack.size(); ++i) {
            graphic.drawAnimation(animationStack.get(i), 0.0f, 0.0f);
        }
    }

    public BoundingBox getBoundingBox() {
        return this.bbMovement;
    }

    public BoundingBox getCollisionBox() {
        return this.bbCollision;
    }

    public BoundingBox getActualBox() {
        return this.bbActual;
    }

    public void setPos(float x, float y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public void playAudio(String name) {
        this.audioMap.get(name).playAsSoundEffect(1.0f, 1.0f, false);
    }

    public String getProperty(String key, String def) {
        String value = this.propertyMap.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public abstract GameObject clone();

    public abstract void accept(Visitor var1);

    public boolean isSolidBlocking() {
        return false;
    }
}

