/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.GameObject;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Moveable
extends GameObject {
    protected Vector2f forward = new Vector2f(1.0f, 0.0f);

    public Moveable(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
    }

    protected boolean move(Vector2f toWhere, MolyJamGame jam, boolean worldCollision, boolean objectCollision) {
        GameWorld world;
        if (worldCollision && (world = jam.getWorld()).isBlocked(this.getBoundingBox(), toWhere)) {
            return false;
        }
        if (worldCollision || objectCollision) {
            ArrayList<GameObject> objs = jam.getGameObjects();
            for (GameObject obj : objs) {
                if (obj == this || (!obj.isSolidBlocking() || !worldCollision) && !objectCollision || !this.getBoundingBox().intersects(toWhere, obj.getBoundingBox(), obj.getPos())) continue;
                return false;
            }
        }
        this.pos = toWhere.copy();
        return true;
    }

    public Vector2f getForward() {
        return this.forward;
    }
}

