/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.TileBasedMapAdapter;
import game.engine.BoundingBox;
import game.objects.Character;
import game.objects.GameObject;
import game.objects.Player;
import game.objects.visitor.Visitor;
import game.world.BlockTester;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Line;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.util.pathfinding.AStarPathFinder;
import org.newdawn.slick.util.pathfinding.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPC
extends Character {
    private static final float NPC_SPEED = 0.075f;
    private static final float PATH_FINDING_SCALE = 8.0f;
    private static final int PATH_AGE_MIN = 250;
    private static final int PATH_AGE_MAX = 1500;
    private static final float NPC_SIGHT_DISTANCE = 300.0f;
    private static final int NPC_ROAM_DELAY_MAX = 2500;
    private static final int NPC_ROAM_DELAY_MIN = 500;
    private static final float NPC_SPEED_SLOW = 0.0375f;
    public static final int NPC_DAMAGE_PER_HIT = 15;
    private static final int NPC_DAMAGE_COOLDOWN = 1500;
    private Path currentPath = null;
    private int currentPathIndex = 0;
    private int pathLife = 0;
    private int roamDelay;
    private Vector2f movement;
    private State state;
    private AIState aiState;
    private boolean requestPending;
    private boolean timeToHurt;
    private int hurtTicker;

    public NPC(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
        this.setState(State.walk_east);
        this.aiState = AIState.idle;
        this.requestPending = false;
        this.roamDelay = 0;
        this.movement = new Vector2f(0.0f, 0.0f);
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        super.update(jam, container, dt);
        if (!this.timeToHurt) {
            this.hurtTicker += dt;
        }
        if (this.hurtTicker >= 1500) {
            this.timeToHurt = true;
        }
        this.pathLife -= dt;
        if (this.aiState == AIState.idle) {
            Player player = jam.getPlayer();
            if (this.canSee(jam.getWorld(), player, 300.0f, true)) {
                this.aiState = AIState.chasing;
            } else if (this.roamDelay <= 0) {
                this.roamDelay = jam.getRandom().nextInt(2000) + 500;
                this.movement = new Vector2f((float)jam.getRandom().nextInt(4) * 90.0f);
            } else {
                this.roamDelay -= dt;
                this.move(jam, this.movement.copy().scale((float)dt * 0.0375f), true);
            }
        } else if (this.aiState == AIState.chasing && !this.canSee(jam.getWorld(), jam.getPlayer(), 300.0f, false)) {
            this.aiState = AIState.idle;
        } else if (this.aiState == AIState.chasing) {
            if (this.pathLife <= 0 && !this.requestPending) {
                jam.requestPathUpdate(this);
                this.requestPending = true;
            }
            if (this.currentPath != null && this.currentPathIndex < this.currentPath.getLength()) {
                float moved = (float)dt * 0.075f;
                while (moved > 0.0f && this.currentPathIndex < this.currentPath.getLength()) {
                    Vector2f next = new Vector2f((float)this.currentPath.getX(this.currentPathIndex) * 8.0f, (float)this.currentPath.getY(this.currentPathIndex) * 8.0f);
                    float distance = this.pos.distance(next);
                    next = next.sub(this.pos).normalise();
                    if (distance <= moved) {
                        next.scale(distance);
                        moved -= distance;
                        ++this.currentPathIndex;
                    } else {
                        next.scale(moved);
                        moved -= moved;
                    }
                    this.move(jam, next, false);
                }
            }
        }
    }

    private void move(MolyJamGame jam, Vector2f movement, boolean collide) {
        if (Math.abs(movement.x) > Math.abs(movement.y)) {
            if (movement.x < 0.0f) {
                this.setState(State.walk_west);
            } else {
                this.setState(State.walk_east);
            }
        } else if (movement.y < 0.0f) {
            this.setState(State.walk_north);
        } else {
            this.setState(State.walk_south);
        }
        this.move(this.pos.copy().add(movement), jam, collide, false);
    }

    private boolean canSee(GameWorld gameWorld, Player player, float npcSightDistance, boolean blockedByWorld) {
        BoundingBox from = this.getBoundingBox();
        BoundingBox to = player.getBoundingBox();
        Line line = new Line(from.getCenterX(this.getPos()), from.getCenterY(this.getPos()), to.getCenterX(player.getPos()), to.getCenterY(player.getPos()));
        if (line.length() > 300.0f) {
            return false;
        }
        final ArrayList<GameObject> solids = this.jam.getSolidBlockingObjects();
        BlockTester bt = new BlockTester(){

            public boolean isBlocked(Vector2f pos) {
                for (GameObject solid : solids) {
                    if (!solid.getBoundingBox().contains(solid.getPos(), pos)) continue;
                    return true;
                }
                return false;
            }
        };
        return !blockedByWorld || !this.jam.getWorld().isBlocked(line, bt);
    }

    public void updatePath(MolyJamGame jam, int dt) {
        Player player = jam.getPlayer();
        Vector2f ppos = player.getPos();
        TileBasedMapAdapter tbm = new TileBasedMapAdapter(jam, 8.0f);
        AStarPathFinder pathFinder = new AStarPathFinder(tbm, 100, false);
        this.currentPath = pathFinder.findPath(new TileBasedMapAdapter.TileBasedMover((Character)this), Math.round(this.pos.x / 8.0f), Math.round(this.pos.y / 8.0f), Math.round(ppos.x / 8.0f), Math.round(ppos.y / 8.0f));
        this.pathLife = jam.getRandom().nextInt(1250) + 250;
        this.currentPathIndex = 1;
        this.requestPending = false;
    }

    public void setState(State state) {
        this.state = state;
        this.currentState = state.name();
    }

    @Override
    public NPC clone() {
        NPC ret = new NPC(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
        return ret;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean isTimeToHurt() {
        return this.timeToHurt;
    }

    public void resetHurtTimer() {
        this.hurtTicker = 0;
        this.timeToHurt = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NPCTypes {
        teddy,
        betty,
        pony;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AIState {
        idle,
        chasing;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        walk_north,
        walk_south,
        walk_west,
        walk_east;

    }
}

