/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.Character;
import game.objects.WallSocket;
import game.objects.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Input;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Player
extends Character {
    protected boolean idle = true;
    protected boolean hasWon;
    protected WallSocket socket;
    protected static float SPEED = 0.1f;
    protected State state = State.idle_east;
    private int lastKey;
    private static final int REGEN_PER_HAPPY_THOUGHT = 2;

    public Player(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
        this.currentState = this.state.name();
        this.socket = null;
        this.lastKey = 157;
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        super.update(jam, container, dt);
        Input input = container.getInput();
        if (input.isKeyDown(17)) {
            this.forward.x = 0.0f;
            this.forward.y = -1.0f;
            this.setState(State.walk_north);
            this.idle = false;
        } else if (input.isKeyDown(31)) {
            this.forward.x = 0.0f;
            this.forward.y = 1.0f;
            this.setState(State.walk_south);
            this.idle = false;
        } else if (input.isKeyDown(30)) {
            this.forward.x = -1.0f;
            this.forward.y = 0.0f;
            this.setState(State.walk_west);
            this.idle = false;
        } else if (input.isKeyDown(32)) {
            this.forward.x = 1.0f;
            this.forward.y = 0.0f;
            this.setState(State.walk_east);
            this.idle = false;
        } else {
            if (!this.idle) {
                switch (this.state) {
                    case walk_north: {
                        this.setState(State.idle_north);
                        break;
                    }
                    case walk_south: {
                        this.setState(State.idle_south);
                        break;
                    }
                    case walk_west: {
                        this.setState(State.idle_west);
                        break;
                    }
                    case walk_east: {
                        this.setState(State.idle_east);
                        break;
                    }
                    default: {
                        this.setState(State.idle_east);
                    }
                }
            }
            this.idle = true;
        }
        if (input.isKeyPressed(18)) {
            this.connectWallSocket(jam);
        }
        boolean hasFired = false;
        boolean rc = false;
        boolean sp = false;
        boolean lc = false;
        while ((rc = input.isKeyPressed(157)) || (sp = input.isKeyPressed(57)) || (lc = input.isKeyPressed(29))) {
            if (rc && this.lastKey != 157) {
                this.lastKey = 157;
                continue;
            }
            if (sp && this.lastKey != 57) {
                this.lastKey = 57;
                continue;
            }
            if (lc && this.lastKey != 29) {
                this.lastKey = 29;
                continue;
            }
            if (!hasFired) {
                this.fire(jam);
            }
            hasFired = true;
        }
        if (!this.idle) {
            float moveAmount = SPEED * (float)dt;
            this.move(new Vector2f(this.pos.x + this.forward.x * moveAmount, this.pos.y + this.forward.y * moveAmount), jam, true, false);
        }
        BoundingBox goal = jam.getWorld().getGoalBounds();
        if (jam.getWorld().getGoalBounds().contains(0.0f, 0.0f, this.pos.x, this.pos.y)) {
            jam.nextLevel();
        }
    }

    public void setState(State state) {
        this.state = state;
        this.currentState = state.name();
    }

    private void connectWallSocket(MolyJamGame jam) {
        if (this.socket != null) {
            this.socket.link(null);
            this.socket = null;
            this.playAudio("power_off");
            return;
        }
        ArrayList<WallSocket> sockets = jam.getWallSockets();
        for (WallSocket s : sockets) {
            if (!this.getBoundingBox().intersects(this.getPos(), s.getCollisionBox(), s.getPos())) continue;
            this.socket = s;
            s.link(this);
            this.playAudio("power_on");
            return;
        }
    }

    private void fire(MolyJamGame jam) {
        if (this.socket != null && this.socket.drain()) {
            jam.spawnShot(new Vector2f(this.pos.x + 8.0f + this.forward.x * 8.0f, this.pos.y + 16.0f + this.forward.y * 8.0f), new Vector2f(this.forward.x, this.forward.y));
            this.playAudio("shoot");
        } else if (this.socket == null && this.health < 100) {
            this.health += 2;
            ConfigurableEmitter happyThoughtEmitter = ((ConfigurableEmitter)this.emitters.get("happythought")).duplicate();
            happyThoughtEmitter.setPosition(this.pos.x, this.pos.y);
            ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)happyThoughtEmitter.angularOffset;
            val.setValue((float)this.forward.getTheta() + 90.0f);
            happyThoughtEmitter.angularOffset = val;
            jam.getParticleSystem().addEmitter(happyThoughtEmitter);
            this.playAudio("happy");
        }
    }

    @Override
    public Player clone() {
        Player ret = new Player(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
        return ret;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public WallSocket getSocket() {
        return this.socket;
    }

    public void detach() {
        this.connectWallSocket(this.jam);
    }

    public boolean hasWon() {
        return this.hasWon;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        walk_north,
        walk_south,
        walk_west,
        walk_east,
        idle_north,
        idle_south,
        idle_west,
        idle_east;

    }
}

