/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.Moveable;
import game.objects.ProjectileGroup;
import game.objects.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projectile
extends Moveable {
    protected int projectileType;
    protected static float SPEED = 0.2f;
    protected int type = 0;
    private int projectilePower = 35;
    private boolean stateSet;
    private boolean moving;
    private State state;
    private Target target;
    private ProjectileGroup group;

    public Projectile(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
        this.setState(State.move_north);
        this.target = Target.enemy;
        this.group = null;
    }

    @Override
    public Projectile clone() {
        Projectile ret = new Projectile(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
        return ret;
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        if (!this.stateSet) {
            if (Math.abs(this.forward.x) > Math.abs(this.forward.y)) {
                if (this.forward.x < 0.0f) {
                    this.setState(State.move_west);
                } else {
                    this.setState(State.move_east);
                }
            } else if (this.forward.y < 0.0f) {
                this.setState(State.move_north);
            } else {
                this.setState(State.move_south);
            }
            this.stateSet = true;
            this.moving = true;
        }
        if (this.moving) {
            this.moving = this.move(new Vector2f(this.pos.x + this.forward.x * SPEED * (float)dt, this.pos.y + this.forward.y * SPEED * (float)dt), jam, true, false);
            if (!this.moving) {
                this.playAudio("hit_wall");
            }
        }
        if (!this.moving) {
            switch (this.state) {
                case move_north: {
                    this.setState(State.stuck_north);
                    break;
                }
                case move_south: {
                    this.setState(State.stuck_south);
                    break;
                }
                case move_west: {
                    this.setState(State.stuck_west);
                    break;
                }
                case move_east: {
                    this.setState(State.stuck_east);
                }
            }
        }
    }

    public void reinit(Vector2f pos, Vector2f dir, Target target) {
        this.pos = pos;
        this.forward = dir;
        this.stateSet = false;
        this.setState(State.move_north);
        for (Map.Entry entry : this.stateMap.entrySet()) {
            for (Animation a : (ArrayList)entry.getValue()) {
                a.restart();
            }
        }
        this.target = target;
        this.group = null;
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void setState(State state) {
        this.state = state;
        this.currentState = state.name();
    }

    public int getProjectilePower() {
        return this.projectilePower;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isActive() {
        return this.group == null || this.group.isActive();
    }

    public ProjectileGroup getGroup() {
        return this.group;
    }

    public void setGroup(ProjectileGroup group) {
        this.group = group;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        player,
        enemy;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectileTypes {
        hatchet,
        knife,
        wrench,
        screwdriver,
        greenpixel;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        move_north,
        move_south,
        move_west,
        move_east,
        stuck_north,
        stuck_south,
        stuck_west,
        stuck_east;

    }
}

