/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.objects.GameDoor;
import game.objects.WallSocket;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedDoor
extends GameDoor {
    protected static final int DOOR_OPEN_TIME = 15000;
    private WallSocket socket = null;
    private int maxOpenTime;
    private int openTime = this.maxOpenTime = 15000;

    public TimedDoor(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
    }

    @Override
    public TimedDoor clone() {
        TimedDoor door = new TimedDoor(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
        door.socket = this.socket;
        return door;
    }

    public void setSocket(WallSocket socket) {
        this.socket = socket;
    }

    public void setDoorTimer(int newTime) {
        this.openTime = newTime;
        this.maxOpenTime = newTime;
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        if (!this.isOpened() && this.socket != null && this.socket.isConnected()) {
            this.openTime -= dt;
            int ds = this.maxOpenTime / 5;
            int state = Math.max(0, Math.min((this.maxOpenTime - this.openTime) / ds, 4));
            if (this.openTime <= 0) {
                this.open();
            } else if (state != this.getOpenState()) {
                this.lower();
            }
        }
    }
}

