/*
 * Decompiled with CFR 0.152.
 */
package game.objects;

import game.MolyJamGame;
import game.TileBasedMapAdapter2;
import game.engine.BoundingBox;
import game.objects.Immovable;
import game.objects.Player;
import game.objects.visitor.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.util.pathfinding.AStarPathFinder;
import org.newdawn.slick.util.pathfinding.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WallSocket
extends Immovable {
    public static final int MAX_CHARGE = 100;
    private static final float PATH_FINDING_SCALE = 8.0f;
    private static final float MAX_DISTANCE = 150.0f;
    private Player linkedPlayer = null;
    private int charge = 100;
    private Animation unplugged;
    private Animation plugged;
    private Path currentPath;
    private int pathLife;
    private int frameIndex;
    private int doorTimer;

    public WallSocket(HashMap<String, ArrayList<Animation>> stateMap, BoundingBox bbMovement, BoundingBox bbCollision, BoundingBox bbActual, HashMap<String, ConfigurableEmitter> emitters, HashMap<String, Audio> audioMap, HashMap<String, String> propertyMap) {
        super(stateMap, bbMovement, bbCollision, bbActual, emitters, audioMap, propertyMap);
        this.currentState = "unplugged";
        this.plugged = stateMap.get("plugged").get(0);
        this.plugged.stop();
        this.plugged.setCurrentFrame(0);
        this.unplugged = stateMap.get("unplugged").get(0);
        this.unplugged.stop();
        this.unplugged.setCurrentFrame(0);
        this.currentPath = null;
        this.pathLife = 0;
    }

    public int getCharge() {
        return this.charge;
    }

    public boolean drain() {
        --this.charge;
        if (this.charge == 0) {
            this.playAudio("depleated");
        }
        if (this.charge > 0) {
            this.frameIndex = (100 - this.charge) / 20;
            return true;
        }
        return false;
    }

    public void link(Player p) {
        this.linkedPlayer = p;
        this.currentState = p == null ? "unplugged" : "plugged";
    }

    private boolean canReachPlayer() {
        Vector2f b;
        if (this.linkedPlayer == null) {
            return false;
        }
        BoundingBox r1 = this.linkedPlayer.getBoundingBox();
        BoundingBox r2 = this.getBoundingBox();
        Vector2f a = new Vector2f(r1.getCenterX(this.linkedPlayer.getPos()), r1.getCenterY(this.linkedPlayer.getPos()));
        return a.distance(b = new Vector2f(r2.getCenterX(this.getPos()), r2.getCenterY(this.getPos()))) <= 150.0f;
    }

    @Override
    public void render(MolyJamGame jam, GameContainer container, Graphics graphic) {
        if (this.currentState == "plugged") {
            this.plugged.setCurrentFrame(this.frameIndex);
            graphic.drawAnimation(this.plugged, 0.0f, 0.0f);
        } else {
            this.unplugged.setCurrentFrame(this.frameIndex);
            graphic.drawAnimation(this.unplugged, 0.0f, 0.0f);
        }
        if (this.linkedPlayer != null) {
            graphic.setColor(Color.black);
            graphic.setLineWidth(3.0f);
            if (this.currentPath != null) {
                float offsetX = 8.0f;
                float offsetY = 32.0f;
                float x = (float)this.currentPath.getStep(0).getX() * 8.0f - this.pos.x + offsetX;
                float y = (float)this.currentPath.getStep(0).getY() * 8.0f - this.pos.y + offsetY;
                graphic.drawLine(this.getActualBox().getMinX(this.getPos()) - this.pos.x + 8.0f, this.getActualBox().getCenterY(this.getPos()) - this.pos.y, x, y);
                for (int i = 0; i < this.currentPath.getLength() - 2; ++i) {
                    float x1 = (float)this.currentPath.getStep(i).getX() * 8.0f - this.pos.x + offsetX;
                    float y1 = (float)this.currentPath.getStep(i).getY() * 8.0f - this.pos.y + offsetY;
                    float x2 = (float)this.currentPath.getStep(i + 1).getX() * 8.0f - this.pos.x + offsetX;
                    float y2 = (float)this.currentPath.getStep(i + 1).getY() * 8.0f - this.pos.y + offsetY;
                    graphic.drawLine(x1, y1, x2, y2);
                }
                float x1 = (float)this.currentPath.getStep(this.currentPath.getLength() - 2).getX() * 8.0f - this.pos.x + offsetX;
                float y1 = (float)this.currentPath.getStep(this.currentPath.getLength() - 2).getY() * 8.0f - this.pos.y + offsetY;
                BoundingBox pbb = this.linkedPlayer.getBoundingBox();
                graphic.drawLine(x1, y1, pbb.getCenterX(this.linkedPlayer.getPos()) - this.pos.x, pbb.getCenterY(this.linkedPlayer.getPos()) - this.pos.y);
            } else {
                BoundingBox pbb = this.linkedPlayer.getBoundingBox();
                graphic.drawLine(this.bbMovement.getCenterX(0.0f, 0.0f), this.bbMovement.getCenterY(0.0f, 0.0f), pbb.getCenterX(this.linkedPlayer.getPos()) - this.pos.x, pbb.getCenterY(this.linkedPlayer.getPos()) - this.pos.y);
            }
        }
    }

    @Override
    public void update(MolyJamGame jam, GameContainer container, int dt) {
        if (this.pathLife <= 0) {
            this.updatePath(jam, dt);
        }
        if (this.linkedPlayer != null && !this.canReachPlayer()) {
            this.linkedPlayer.detach();
        }
        this.pathLife -= dt;
    }

    @Override
    public WallSocket clone() {
        return new WallSocket(this.stateMap, this.bbMovement, this.bbCollision, this.bbActual, this.emitters, this.audioMap, this.propertyMap);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void updatePath(MolyJamGame jam, int dt) {
        if (this.linkedPlayer != null) {
            Player player = jam.getPlayer();
            Vector2f ppos = player.getPos();
            TileBasedMapAdapter2 tbm = new TileBasedMapAdapter2(jam, 8.0f);
            AStarPathFinder pathFinder = new AStarPathFinder(tbm, 400, true);
            this.currentPath = pathFinder.findPath(new TileBasedMapAdapter2.TileBasedMover(this), Math.round(this.pos.x / 8.0f), Math.round(this.pos.y / 8.0f), Math.round((ppos.x + 8.0f) / 8.0f), Math.round(ppos.y / 8.0f));
            this.pathLife = 100;
        }
    }

    public boolean isConnected() {
        return this.linkedPlayer != null;
    }

    public void setDoorTimer(int time) {
        this.doorTimer = time;
    }

    public int getDoorTimer() {
        return this.doorTimer;
    }
}

