/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.loader.EntityLoader;
import game.engine.util.ObjectManager;
import game.entities.Entity;
import game.entities.NPC;
import game.entities.Player;
import game.map.GameMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameWorld {
    private Random random = new Random();
    private EntityLoader loader;
    private ObjectManager<Entity> objects;
    private GameMap map;
    private GameCamera camera;
    private ArrayList<NPC> updateRequests;

    public GameWorld(EntityLoader loader, GameMap map) {
        this.loader = loader;
        this.map = map;
        this.camera = new GameCamera();
        this.objects = new ObjectManager<Entity>(Entity.class);
        this.objects.installTypeMapping(Player.class);
        this.updateRequests = new ArrayList();
    }

    public Random getRandom() {
        return this.random;
    }

    public GameMap getMap() {
        return this.map;
    }

    public EntityLoader getLoader() {
        return this.loader;
    }

    public ObjectManager<Entity> getEntities() {
        return this.objects;
    }

    public List<Entity> getSolidBlockingEntities() {
        List<Entity> entities = this.objects.get();
        Iterator<Entity> it = entities.iterator();
        while (it.hasNext()) {
            if (it.next().isSolidBlocking()) continue;
            it.remove();
        }
        return entities;
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public Player getPlayer() {
        return this.objects.getOne(Player.class);
    }

    public void update(int dt, GameContainer container) {
        this.camera.update(this, dt);
        for (Entity o : this.objects.get()) {
            o.update(dt, this, container);
        }
        if (this.updateRequests.size() > 0) {
            this.updateRequests.remove(0).updatePath(this, dt);
        }
    }

    public void render(Graphics g, GameContainer container) {
        this.camera.apply(g, container);
        BoundingBox screenBounds = this.camera.getScreenBounds();
        Vector2f screenPos = this.camera.getScreenPos();
        this.map.renderLayers(g, GameMap.LayerType.ground, screenBounds, screenPos);
        this.map.renderLayers(g, GameMap.LayerType.wall, screenBounds, screenPos);
        this.map.renderLayers(g, GameMap.LayerType.occlusion, screenBounds, screenPos);
        this.map.renderLayers(g, GameMap.LayerType.object, screenBounds, screenPos);
        List<Entity> objs = this.objects.get();
        Collections.sort(objs, new RenderComparator());
        for (Entity o : objs) {
            g.pushTransform();
            if (o.preRender(g, this, container)) {
                o.render(g, this, container);
                o.postRender(g, this, container);
            }
            g.popTransform();
        }
        this.map.renderLayers(g, GameMap.LayerType.roof, screenBounds, screenPos);
    }

    public void requestPathUpdate(NPC npc) {
        this.updateRequests.add(npc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenderComparator
    implements Comparator<Entity> {
        private RenderComparator() {
        }

        @Override
        public int compare(Entity a, Entity b) {
            return a.compareRenderOrder(b);
        }
    }
}

